
#include <iostream>
#include "PolymerSystem.hpp"
#include "H5Cpp.h"

int main(int argc, const char * argv[]) {
    
    //system parameters
    const int critical_ring_size=2;
    const long initial_particales=0;
    const long inactive_particles=100;
    double activation_rate=0.000001;
    const double dimerization_rate=1;
    const double decay_rate=0;
    unsigned seed=time(nullptr);//best use a real random number
    
    //perform all simulations
    std::vector<double> results;
    for (int i=0; i<15; ++i) {
        double yield=0;
        Complete_System sys(critical_ring_size,initial_particales,inactive_particles,activation_rate,dimerization_rate,decay_rate,seed);
        sys.GetEnsAv(20, &yield);
        
        results.push_back(double(number_of_species));
        results.push_back(double(inactive_particles));
        results.push_back(double(activation_rate));
        results.push_back(yield);
        
        //exponential growth of the activation rate
        activation_rate*=10;
    }
    
    //write results to hdf5
    hsize_t dims[2];
    dims[0]=results.size()/4;
    dims[1]=4;
    H5::H5File file("results.hdf5",H5F_ACC_TRUNC);
    H5::DataSpace dataspace(2,dims);
    H5::DataSet dataset=file.createDataSet("results", H5::PredType::NATIVE_DOUBLE, dataspace);
    dataset.write(results.data(), H5::PredType::NATIVE_DOUBLE);
    file.close();
    
    return 0;
}
